<?php

class ShowSimilarThreads_Search_SourceHandler_ElasticSearch extends XenES_Search_SourceHandler_ElasticSearch
{
	public function executeSearch($searchQuery, $titleOnly, array $processedConstraints, array $orderParts,
		$groupByDiscussionType, $maxResults, XenForo_Search_DataHandler_Abstract $typeHandler = null)
	{
		if ($maxResults < 1)
		{
			$maxResults = 100;
		}
		$maxResults = intval($maxResults);
	
		// search terms
		$searchQuery = $this->parseQuery($searchQuery);
		if ($searchQuery !== '')
		{
			$queryDsl = array(
				'query_string' => array(
					'query' => $searchQuery,
					'fields' => $titleOnly ? array('title') : array('title', 'message'),
					'default_operator' => 'or'
				)
			);
		}
		else
		{
			$queryDsl = array(
				'match_all' => new stdClass()
			);
		}
	
		// constraints
		$dsl = array();
	
		foreach ($processedConstraints AS $constraintName => $constraint)
		{
			if ($this->_processConstraint($dsl, $constraintName, $constraint))
			{
				unset($processedConstraints[$constraintName]);
			}
		}
	
		// DSL 'filtered' if necessary
		if (empty($dsl['query']['filtered']['filter']))
		{
			$dsl['query'] = $queryDsl;
		}
		else
		{
			$dsl['query']['filtered']['query'] = $queryDsl;
		}
	
		$sqlTables = array();
		$sqlSort = array();
		$sqlConditions = array();
	
		// ordering
		foreach ($orderParts AS $order)
		{
			if ($order[0] == 'search_index')
			{
				// sorting on field in the search index - can use ES
				if ($order[1] == 'item_date')
				{
					$order[1] = 'date';
				}
				else if ($order[1] == 'relevance')
				{
					$order[1] = '_score';
				}
				$dsl['sort'][] = array($order[1] => $order[2]);
			}
			else
			{
				$sqlSort[] = $order;
				$sqlTables[] = $order[0];
			}
		}
	
		$dsl['size'] = $maxResults;
		$dsl['fields'] = array('discussion_id', 'user', 'date');
	
		if ($groupByDiscussionType)
		{
			$dsl['size'] *= 4; // post result filtering
		}
	
		if (!empty($processedConstraints))
		{
			$dsl['size'] *= 4; // in sql filtering
	
			foreach ($processedConstraints AS $constraintName => $constraint)
			{
				$this->_processSqlConstraint($constraint, $sqlConditions, $sqlTables);
			}
		}
	
		$response = XenES_Api::search($this->_indexName, $dsl);
		if (!$response || !isset($response->hits, $response->hits->hits))
		{
			$this->_logSearchResponseError($response, true);
			throw new XenForo_Exception(new XenForo_Phrase('search_could_not_be_completed_try_again_later'), true);
		}
	
		$hits = $response->hits->hits;
		if ($sqlTables && $typeHandler)
		{
			// need to return more entries if grouping by discussion to be filtered later
			$hits = $this->_getSqlLimitedHits(
				$hits, $sqlTables, $sqlConditions, $sqlSort,
				($groupByDiscussionType ? $maxResults * 4 : $maxResults), $typeHandler
			);
		}
	
		$results = $this->_getResultsFromHits($hits, $groupByDiscussionType);
		$results = array_slice($results, 0, $maxResults);
	
		return $results;
	}
}